<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShipmentsTable extends Migration {

	public function up()
	{
		Schema::create('shipments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('sender_id');
			$table->string('receiver_name');
			$table->string('receiver_email');
			$table->string('receiver_phone_number');
			$table->string('longitute');
			$table->string('latitute');
			$table->double('width');
			$table->double('length');
			$table->double('height');
			$table->double('weight');
			$table->enum('status', array(''));
			$table->double('quantity');
			$table->text('notes');
			$table->string('shipment_category');
			$table->timestamps();
			$table->string('code');
		});
	}

	public function down()
	{
		Schema::drop('shipments');
	}
}