<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('shipping_service', function(Blueprint $table) {
			$table->foreign('shipping_gateway_id')->references('id')->on('shipping_gateway')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('config_field_value', function(Blueprint $table) {
			$table->foreign('config_field_id')->references('id')->on('config_field')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('shipping_service_id')->references('id')->on('shipping_service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('shipping_service', function(Blueprint $table) {
			$table->dropForeign('shipping_service_shipping_gateway_id_foreign');
		});
		Schema::table('config_field_value', function(Blueprint $table) {
			$table->dropForeign('config_field_value_config_field_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_shipping_service_id_foreign');
		});
	}
}