<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayrollsTable extends Migration {

	public function up()
	{
		Schema::create('payrolls', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('employee_id')->unsigned();
			$table->smallInteger('month');
			$table->integer('year');
			$table->double('basic_salary');
			$table->double('positional_allowance');
			$table->double('family_allowance');
			$table->double('rice_allowance');
			$table->double('food_fund');
			$table->double('transport_allowance');
			$table->double('housing_allowance');
			$table->double('incentive');
			$table->double('overcharge_allowance');
			$table->double('bpjs_kesehatan_allowance');
			$table->double('bpjs_jht_allowance');
			$table->double('bpjs_pensiun_allowance');
			$table->double('bpjs_kk_allowance');
			$table->double('bpjs_kematian_allowance');
			$table->date('payment_date');
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payrolls');
	}
}