<?php

namespace EmployeeStatus;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmployeeStatus extends Eloquent {

	protected $table = 'employee_status';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function employeeStatusBelongsToEmployee()
	{
		return $this->belongsTo('Employees', 'employee_id');
	}

}