<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('families', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('families', function(Blueprint $table) {
			$table->foreign('applicant_id')->references('id')->on('applicants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pensions', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payrolls', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cuts', function(Blueprint $table) {
			$table->foreign('payroll_id')->references('id')->on('payrolls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('savings', function(Blueprint $table) {
			$table->foreign('payroll_id')->references('id')->on('payrolls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('savings', function(Blueprint $table) {
			$table->foreign('saving_product_id')->references('id')->on('saving_products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee_group', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee_group', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee_status', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('families', function(Blueprint $table) {
			$table->dropForeign('families_employee_id_foreign');
		});
		Schema::table('families', function(Blueprint $table) {
			$table->dropForeign('families_applicant_id_foreign');
		});
		Schema::table('pensions', function(Blueprint $table) {
			$table->dropForeign('pensions_employee_id_foreign');
		});
		Schema::table('payrolls', function(Blueprint $table) {
			$table->dropForeign('payrolls_employee_id_foreign');
		});
		Schema::table('cuts', function(Blueprint $table) {
			$table->dropForeign('cuts_payroll_id_foreign');
		});
		Schema::table('savings', function(Blueprint $table) {
			$table->dropForeign('savings_payroll_id_foreign');
		});
		Schema::table('savings', function(Blueprint $table) {
			$table->dropForeign('savings_saving_product_id_foreign');
		});
		Schema::table('employee_group', function(Blueprint $table) {
			$table->dropForeign('employee_group_employee_id_foreign');
		});
		Schema::table('employee_group', function(Blueprint $table) {
			$table->dropForeign('employee_group_group_id_foreign');
		});
		Schema::table('employee_status', function(Blueprint $table) {
			$table->dropForeign('employee_status_employee_id_foreign');
		});
	}
}