<?php

namespace EmployeeGroup;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmployeeGroup extends Eloquent {

	protected $table = 'employee_group';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function employeeGroupHasManyGroup()
	{
		return $this->hasMany('Group');
	}

	public function employeeGroupBelongsToEmployee()
	{
		return $this->belongsTo('Employees');
	}

}