<?php

namespace Employees;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Employees extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function employeeHasManyPayroll()
	{
		return $this->hasMany('Payroll', 'employee_id');
	}

	public function employeeHasManyFamily()
	{
		return $this->hasMany('Applicants', 'employee_id');
	}

	public function employeeHasManyFamily()
	{
		return $this->hasMany('Families', 'employee_id');
	}

	public function employeeHasManyAttendance()
	{
		return $this->hasMany('Attendance', 'employee_id');
	}

}