<?php

namespace Saving;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Saving extends Eloquent {

	protected $table = 'savings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function savingHasOnePayroll()
	{
		return $this->hasMany('Payroll', 'payroll_id');
	}

	public function savingHasManySavingProduct()
	{
		return $this->hasMany('SavingProduct', 'saving_product_id');
	}

}