<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lesson extends Model 
{

    protected $table = 'lessons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function lessonable()
    {
        return $this->morphTo();
    }

    public function parts()
    {
        return $this->belongsToMany('LessonParts', 'lesson_parts_map')->withPivot('order');
    }

}