<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LessonParts extends Model 
{

    protected $table = 'lesson_parts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function lessons()
    {
        return $this->belongsToMany('Lesson', 'lesson_parts_map')->withPivot('order');
    }

    public function type()
    {
        return $this->belongsTo('LessonPartType');
    }

}