<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaskFieldsTable extends Migration {

	public function up()
	{
		Schema::create('task_fields', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('task_id')->unsigned();
			$table->bigInteger('task_field_template_id')->unsigned();
			$table->string('value')->nullable();
			$table->boolean('is_ready')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('task_fields');
	}
}