<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('parent_id')->unsigned();
			$table->boolean('is_required')->default(true);
			$table->json('details');
			$table->json('fields');
			$table->bigInteger('task_template_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}