<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShopsTable extends Migration {

	public function up()
	{
		Schema::create('shops', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100);
			$table->integer('cityID');
			$table->integer('distID');
			$table->string('address', 500);
			$table->string('note', 5000);
			$table->integer('phase');
		});
	}

	public function down()
	{
		Schema::drop('shops');
	}
}