<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuccessResultsTable extends Migration {

	public function up()
	{
		Schema::create('successResults', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('userID');
			$table->string('phone', 25);
			$table->integer('shopID');
			$table->integer('productID');
			$table->string('cupponCode', 20);
			$table->integer('status')->default('0');
			$table->integer('phase')->default('4');
			$table->integer('type');
		});
	}

	public function down()
	{
		Schema::drop('successResults');
	}
}