<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFixedAssetsTable extends Migration {

	public function up()
	{
		Schema::create('fixed_assets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->datetime('date')->nullable();
			$table->double('price')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->integer('category_id')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('fixed_assets');
	}
}