<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CapitalTransaction extends Model 
{

    protected $table = 'capital_transaction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('partner_id', 'amount', 'date', 'notes', 'country_id', 'mall_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

    public function partner()
    {
        return $this->belongsTo('Partner', 'partner_id');
    }

}