<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'product';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'serial', 'category_id', 'barcode', 'amount', 'buy_price', 'sellable', 'country_id', 'mall_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

    public function category()
    {
        return $this->belongsTo('ProductCategory', 'category_id');
    }

}