<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Employee extends Model 
{

    protected $table = 'employee';
    public $timestamps = true;
    protected $guarded = array('employee_id', 'timestamps');
    protected $fillable = array('firstname', 'lastname', 'dni', 'payroll', 'costCenter', 'adminPosition', 'enterpriseheadquarter_id', 'status', 'enterprise_id');

    public function getActivityEmployee()
    {
        return $this->hasMany('App\ActivityEmployee', 'employee_id');
    }

    public function getEnterpriseHeadquarter()
    {
        return $this->hasOne('App\EnterpriseHeadquarter', 'enterpriseheadquarter_id');
    }

    public function getEnterprise()
    {
        return $this->hasOne('App\Enterprise', 'enterprise_id');
    }

}