<?php

namespace App;

class Turn extends Eloquent {

	protected $table = 'turn';
	public $timestamps = true;
	protected $guarded = array('turn_id', 'timestamps');
	protected $fillable = array('name', 'beginDateTime', 'endDateTime', 'tareoType', 'status');

	public function getPlanningTurns()
	{
		return $this->hasMany('App\PlanningTurn', 'turn_id');
	}

	public function getTurnActivities()
	{
		return $this->hasMany('App\TurnActivity', 'turn_id');
	}

}