<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->string('name', 255);
			$table->string('slug');
			$table->float('price')->default('0');
			$table->float('compare_price');
			$table->longText('description');
			$table->boolean('is_active');
			$table->boolean('best_sellar');
			$table->integer('stock');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}