<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('order_number');
			$table->float('discount');
			$table->float('tax');
			$table->float('prefinal_total');
			$table->float('final_total');
			$table->enum('status', array('pending', 'processing', 'delivering', 'completed', 'canceled'));
			$table->enum('payment_status', array('paid', 'unpaid', 'failed'));
			$table->string('options');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}