<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('institutions', function(Blueprint $table) {
			$table->foreign('id_type')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('institutions', function(Blueprint $table) {
			$table->foreign('id_professionnels')->references('id')->on('professionnels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('adresses', function(Blueprint $table) {
			$table->foreign('id_countrie')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('adresses', function(Blueprint $table) {
			$table->foreign('id_institution')->references('id')->on('institutions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('id_institution')->references('id')->on('institutions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hours', function(Blueprint $table) {
			$table->foreign('id_institution')->references('id')->on('institutions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activitys_institutions', function(Blueprint $table) {
			$table->foreign('id_institution')->references('id')->on('institutions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activitys_institutions', function(Blueprint $table) {
			$table->foreign('id_activitie')->references('id')->on('activities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('id_activitie')->references('id')->on('activities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prestations', function(Blueprint $table) {
			$table->foreign('id_service')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('calendars', function(Blueprint $table) {
			$table->foreign('id_prestation')->references('id')->on('prestations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees_prestations', function(Blueprint $table) {
			$table->foreign('id_prestation')->references('id')->on('prestations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees_prestations', function(Blueprint $table) {
			$table->foreign('id_employee')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('socials_accounts', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('institutions', function(Blueprint $table) {
			$table->dropForeign('institutions_id_type_foreign');
		});
		Schema::table('institutions', function(Blueprint $table) {
			$table->dropForeign('institutions_id_professionnels_foreign');
		});
		Schema::table('adresses', function(Blueprint $table) {
			$table->dropForeign('adresses_id_countrie_foreign');
		});
		Schema::table('adresses', function(Blueprint $table) {
			$table->dropForeign('adresses_id_institution_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_id_institution_foreign');
		});
		Schema::table('hours', function(Blueprint $table) {
			$table->dropForeign('hours_id_institution_foreign');
		});
		Schema::table('activitys_institutions', function(Blueprint $table) {
			$table->dropForeign('activitys_institutions_id_institution_foreign');
		});
		Schema::table('activitys_institutions', function(Blueprint $table) {
			$table->dropForeign('activitys_institutions_id_activitie_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_id_activitie_foreign');
		});
		Schema::table('prestations', function(Blueprint $table) {
			$table->dropForeign('prestations_id_service_foreign');
		});
		Schema::table('calendars', function(Blueprint $table) {
			$table->dropForeign('calendars_id_prestation_foreign');
		});
		Schema::table('employees_prestations', function(Blueprint $table) {
			$table->dropForeign('employees_prestations_id_prestation_foreign');
		});
		Schema::table('employees_prestations', function(Blueprint $table) {
			$table->dropForeign('employees_prestations_id_employee_foreign');
		});
		Schema::table('socials_accounts', function(Blueprint $table) {
			$table->dropForeign('socials_accounts_id_user_foreign');
		});
	}
}