<?php

namespace App;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;
	protected $fillable = array('title', 'user_id');

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function tags()
	{
		return $this->morphedByMany('App\Tag', 'taggable');
	}

	public function comments()
	{
		return $this->morphMany('App\Comment', 'commentable');
	}

}