<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('Products', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('merchant_id')->unsigned();
			$table->string('product_name');
			$table->text('description');
			$table->decimal('price');
			$table->string('image_url');
		});
	}

	public function down()
	{
		Schema::drop('Products');
	}
}