<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Merchants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('merchant_id')->references('id')->on('Merchants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Guides', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Tours', function(Blueprint $table) {
			$table->foreign('guide_id')->references('id')->on('Guides')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->foreign('tour_id')->references('id')->on('Tours')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PaymentTransactions', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('Bookings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Merchants', function(Blueprint $table) {
			$table->dropForeign('Merchants_user_id_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Products_merchant_id_foreign');
		});
		Schema::table('Guides', function(Blueprint $table) {
			$table->dropForeign('Guides_user_id_foreign');
		});
		Schema::table('Tours', function(Blueprint $table) {
			$table->dropForeign('Tours_guide_id_foreign');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->dropForeign('Bookings_user_id_foreign');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->dropForeign('Bookings_tour_id_foreign');
		});
		Schema::table('PaymentTransactions', function(Blueprint $table) {
			$table->dropForeign('PaymentTransactions_booking_id_foreign');
		});
	}
}