<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('Bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('tour_id')->unsigned();
			$table->date('booking_date');
			$table->integer('number_of_guests');
			$table->decimal('total_price');
			$table->enum('payment_status', array('pending', 'completed', 'failed'));
		});
	}

	public function down()
	{
		Schema::drop('Bookings');
	}
}