<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateToursTable extends Migration {

	public function up()
	{
		Schema::create('Tours', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('guide_id')->unsigned();
			$table->string('tour_name');
			$table->text('description');
			$table->decimal('price');
			$table->string('location');
			$table->date('available_dates');
			$table->integer('max_capacity');
		});
	}

	public function down()
	{
		Schema::drop('Tours');
	}
}