<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIncomingMailTable extends Migration {

	public function up()
	{
		Schema::create('incoming_mail', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('no');
			$table->string('full_number');
			$table->string('description');
			$table->string('sign_date');
			$table->string('sign_place');
			$table->bigInteger('unit_id');
			$table->string('sign_user');
			$table->bigInteger('classification_id');
			$table->bigInteger('priority_id');
			$table->string('status');
			$table->string('publish_date');
			$table->string('user_id_created');
			$table->bigIncrements('type_id');
		});
	}

	public function down()
	{
		Schema::drop('incoming_mail');
	}
}