<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnswersTable extends Migration {

	public function up()
	{
		Schema::create('answers', function(Blueprint $table) {
			$table->increments('id');
			$table->text('description');
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
			$table->integer('answer_id');
			$table->integer('user_id')->unsigned();
			$table->integer('question_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('answers');
	}
}