<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = false;
    protected $fillable = array('name', 'email', 'password');
    protected $hidden = array('password', 'remember_token');

    public function answer()
    {
        return $this->hasMany('App\Answer');
    }

    public function question()
    {
        return $this->hasMany('App\Question');
    }

    public function passwordReset()
    {
        return $this->hasMany('Illuminate\Auth\Events;\PasswordReset');
    }

}