<?php

namespace App/Model/;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;
    protected $fillable = array('name', 'governorate_id');

    public function client()
    {
        return $this->belongsTo('App/Model/\Client');
    }

    public function donationRequest()
    {
        return $this->belongsTo('App/Model/\Donation_request');
    }

    public function governorate()
    {
        return $this->belongsTo('App/Model/\Governorate');
    }

}