<?php

namespace App/Model/;

class Donation_request extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $fillable = array('patient_name', 'patient_phone', 'city_id', 'client_id', 'hospital_name', 'blood_type_id', 'patient_age', 'bags_num', 'hospital_address', 'latitude', 'longitude');

	public function bloodType()
	{
		return $this->hasOne('App/Model/\Blood_type');
	}

	public function city()
	{
		return $this->hasOne('App/Model/\City');
	}

	public function client()
	{
		return $this->hasOne('App/Model/\Client');
	}

	public function notification()
	{
		return $this->belongsTo('App/Model/\Notification');
	}

}