<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'tickets_count', 'note', 'location_id', 'event_id', 'payment_type', 'status', 'price');
    protected $visible = array('user_id', 'tickets_count', 'note', 'location_id', 'event_id', 'payment_type', 'status', 'price');

    public function user()
    {
        return $this->hasOne('User', 'user_id');
    }

    public function location()
    {
        return $this->hasOne('Location', 'location_id');
    }

    public function tickets()
    {
        return $this->hasMany('Ticket');
    }

    public function event()
    {
        return $this->hasOne('Event', 'event_id');
    }

}