<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model 
{

    protected $table = 'tickets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('price', 'order_id', 'status', 'ticket_class_id');
    protected $visible = array('price', 'order_id', 'status', 'ticket_class_id');

    public function order()
    {
        return $this->hasOne('Order', 'order_id');
    }

    public function class()
    {
        return $this->hasOne('TicketClass', 'ticket_class_id');
    }

}