<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;

class TicketClass extends Model 
{

    protected $table = 'ticket_classes';
    public $timestamps = true;
    protected $fillable = array('event_id', 'price', 'tickets_count', 'booked_tickets_count');
    protected $visible = array('event_id', 'price', 'tickets_count', 'booked_tickets_count');

    public function event()
    {
        return $this->hasOne('Event', 'event_id');
    }

    public function tickets()
    {
        return $this->hasMany('Ticket');
    }

}