<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->string('coordinate');
			$table->string('street');
			$table->string('governorate');
			$table->string('city');
			$table->string('note')->nullable();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}