<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('price', 10,10);
			$table->integer('order_id')->unsigned();
			$table->smallInteger('status');
			$table->integer('ticket_class_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}