<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('admin_id', 'description', 'title', 'start_date', 'end_date', 'start_time', 'end_time', 'booking_start_time', 'booking_end_time');
    protected $visible = array('admin_id', 'description', 'title', 'start_date', 'end_date', 'start_time', 'end_time', 'booking_start_time', 'booking_end_time');

    public function admin()
    {
        return $this->hasOne('Admin', 'admin_id');
    }

    public function orders()
    {
        return $this->hasMany('Order');
    }

    public function ticketsClasses()
    {
        return $this->hasMany('TicketClass');
    }

}