<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('admin_id')->unsigned();
			$table->longText('description')->nullable();
			$table->string('title');
			$table->date('start_date');
			$table->date('end_date');
			$table->time('start_time');
			$table->time('end_time');
			$table->datetime('booking_start_time');
			$table->datetime('booking_end_time')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}