<?php

namespace App/Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'phone', 'avatar', 'disabled');
	protected $visible = array('name', 'phone', 'avatar', 'disabled');

	public function orders()
	{
		return $this->hasMany('Order');
	}

	public function locations()
	{
		return $this->hasMany('Location');
	}

}