<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 17)->nullable();
			$table->string('phone', 16)->unique();
			$table->string('avatar', 255)->nullable();
			$table->boolean('disabled')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}