<?php

namespace App/Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ticket extends Eloquent {

	protected $table = 'tickets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('price', 'order_id', 'status', 'ticket_class_id');
	protected $visible = array('price', 'order_id', 'status', 'ticket_class_id');

	public function order()
	{
		return $this->hasOne('Order', 'order_id');
	}

	public function class()
	{
		return $this->hasOne('TicketClass', 'ticket_class_id');
	}

}