<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('workflow', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->foreign('presenter_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('partners')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->foreign('template_id')->references('id')->on('templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->foreign('reject_reason_id')->references('id')->on('reject_reasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->foreign('assign_to')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->foreign('rated_by')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agreement_files', function(Blueprint $table) {
			$table->foreign('agreement_id')->references('id')->on('agreements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('agreement_workflows', function(Blueprint $table) {
			$table->foreign('agreement_id')->references('id')->on('agreement_workflows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agreement_workflows', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agreement_plan_terms', function(Blueprint $table) {
			$table->foreign('agreement_id')->references('id')->on('agreements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agreement_plan_terms', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('challenges')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->foreign('agreement_plan_term_id')->references('id')->on('agreement_plan_terms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('workflow', function(Blueprint $table) {
			$table->dropForeign('workflow_user_id_foreign');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->dropForeign('partners_user_id_foreign');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->dropForeign('partners_presenter_id_foreign');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->dropForeign('departments_parent_id_foreign');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->dropForeign('agreements_partner_id_foreign');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->dropForeign('agreements_template_id_foreign');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->dropForeign('agreements_reject_reason_id_foreign');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->dropForeign('agreements_assign_to_foreign');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->dropForeign('agreements_created_by_foreign');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->dropForeign('agreements_rated_by_foreign');
		});
		Schema::table('agreement_files', function(Blueprint $table) {
			$table->dropForeign('agreement_files_agreement_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_user_id_foreign');
		});
		Schema::table('agreement_workflows', function(Blueprint $table) {
			$table->dropForeign('agreement_workflows_agreement_id_foreign');
		});
		Schema::table('agreement_workflows', function(Blueprint $table) {
			$table->dropForeign('agreement_workflows_user_id_foreign');
		});
		Schema::table('agreement_plan_terms', function(Blueprint $table) {
			$table->dropForeign('agreement_plan_terms_agreement_id_foreign');
		});
		Schema::table('agreement_plan_terms', function(Blueprint $table) {
			$table->dropForeign('agreement_plan_terms_department_id_foreign');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->dropForeign('challenges_parent_id_foreign');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->dropForeign('challenges_agreement_plan_term_id_foreign');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->dropForeign('challenges_created_by_foreign');
		});
	}
}