<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgreementWorkflowsTable extends Migration {

	public function up()
	{
		Schema::create('agreement_workflows', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('agreement_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->string('title');
			$table->longText('comments')->nullable();
			$table->enum('status', array('pending', 'accept', 'reject'));
			$table->boolean('final_action')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('agreement_workflows');
	}
}