<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgreementsTable extends Migration {

	public function up()
	{
		Schema::create('agreements', function(Blueprint $table) {
			$table->increments('id');
			$table->json('subject');
			$table->bigInteger('partner_id')->unsigned();
			$table->enum('side_type', array('first', 'second'));
			$table->enum('category', array('private', 'public', 'non_profit'));
			$table->bigInteger('template_id')->unsigned();
			$table->enum('type', array('income', 'outcome'));
			$table->date('invitation_date');
			$table->boolean('send_by_email')->default(0);
			$table->boolean('send_by_letter')->default(0);
			$table->enum('received_by', array('email', 'letter', 'api'));
			$table->longText('terms');
			$table->string('email')->nullable();
			$table->enum('response', array('pending', 'accept', 'reject'));
			$table->bigInteger('reject_reason_id')->unsigned();
			$table->bigInteger('assign_to')->unsigned()->nullable();
			$table->bigInteger('created_by')->unsigned();
			$table->enum('status', array('request', 'inprogress', 'rejected', 'draft'));
			$table->string('duration');
			$table->string('rate')->nullable();
			$table->longText('rate_review')->nullable();
			$table->bigInteger('rated_by')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('agreements');
	}
}