<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChallengesTable extends Migration {

	public function up()
	{
		Schema::create('challenges', function(Blueprint $table) {
			$table->increments('id');
			$table->longText('description')->nullable();
			$table->bigInteger('parent_id')->unsigned()->nullable();
			$table->timestamps();
			$table->bigInteger('agreement_plan_term_id')->unsigned();
			$table->bigInteger('created_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('challenges');
	}
}