<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgreementFilesTable extends Migration {

	public function up()
	{
		Schema::create('agreement_files', function(Blueprint $table) {
			$table->increments('id');
			$table->string('file');
			$table->enum('type', array('general', 'agreement', 'reject', 'accept'));
			$table->timestamps();
			$table->bigInteger('agreement_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('agreement_files');
	}
}