<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBooksTable extends Migration {

	public function up()
	{
		Schema::create('books', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->longText('details');
			$table->longText('summary')->nullable();
			$table->string('language')->nullable();
			$table->integer('pages_count');
			$table->integer('views');
			$table->bigInteger('author_id')->unsigned()->nullable();
			$table->bigInteger('category_id')->unsigned()->nullable();
			$table->string('file')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('books');
	}
}