<?php

namespace App\Models;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;
	protected $fillable = array('title', 'created_by');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'created_by');
	}

	public function books()
	{
		return $this->hasMany('App\Models\Book', 'category_id');
	}

	public function catergoies_parents()
	{
		return $this->hasMany('App\Models\CategoryParent', 'category_id');
	}

}