<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CategoryParent extends Eloquent {

	protected $table = 'categories_parents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'category_id', 'created_by');

	public function category()
	{
		return $this->belongsTo('App\Models\Category', 'category_id');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

}